/*
 *Phtotorésistance et LED
 *30 mai 2021
 *Prof-TC
 */

const char led = 2;            // Cette LED indiquera s'il fait jour
const char capteur = 0;        // Sur la broche A0 est connecté le pont diviseur de tension

float tension = 0;             // "tension" est la variable qui enregistre la tension lue en sortie du capteur
float seuil = 1.0;             // "seuil" est la valeur en V qui détermine le niveau auquel l'obscurité est présente

void setup()
{
    pinMode(led, OUTPUT);      // définition des broches utilisées
    Serial.begin(9600);        // la voie série pour monitorer
}

void loop()
{
    tension = (analogRead(capteur) * 5.0) / 1024;     // conversion de cette valeur en tension

    if(tension <= seuil)
    {
        digitalWrite(led, LOW);                       // On allume la LED
    }
    else
    {
        digitalWrite(led, HIGH);                      // On éteint la LED
    }
    Serial.print("Tension = ");                       // envoie de la valeur de la tension lue vers l'ordinateur via la liaison série
    Serial.print(tension);
    Serial.println(" V");

   delay(500);                                        // délai pour ne prendre des mesures que toutes les demi-secondes
}
